<?php
/* --------------------------------------------------------------
   Language.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Language\Model;

use Gambio\Core\Language\LanguageCode;
use Gambio\Core\Language\LanguageId;

/**
 * Class Language
 *
 * @package Gambio\Core\Language\Model
 */
class Language implements \Gambio\Core\Language\Language
{
    /**
     * @var LanguageId
     */
    private $id;
    
    /**
     * @var LanguageCode
     */
    private $code;
    
    /**
     * @var string
     */
    private $name;
    
    
    /**
     * Language constructor.
     *
     * @param LanguageId   $id
     * @param LanguageCode $code
     * @param string       $name
     */
    private function __construct(LanguageId $id, LanguageCode $code, string $name)
    {
        $this->id   = $id;
        $this->code = $code;
        $this->name = $name;
    }
    
    
    /**
     * @param LanguageId   $id
     * @param LanguageCode $code
     * @param string       $name
     *
     * @return Language
     */
    public static function create(LanguageId $id, LanguageCode $code, string $name): Language
    {
        return new self($id, $code, $name);
    }
    
    
    /**
     * @inheritDoc
     */
    public function id(): int
    {
        return $this->id->value();
    }
    
    
    /**
     * @inheritDoc
     */
    public function code(): string
    {
        return $this->code->value();
    }
    
    
    /**
     * @inheritDoc
     */
    public function name(): string
    {
        return $this->name;
    }
}